// To find the signal to noise ratio for satelite communication link for given input power
//OS=Windows XP sp3
//Scilab version 5.4.0
//Sample Values
//F=6.1
//Gtdb=54
//R=37500
//Losses=6
//Pt=100
//Grdb=26
//Ta=35
//Tr=500
//B=36
clear;
close;
clc;
F=input("enter the value of frequency in Ghz F");
c=3e8;
lambda= c/(F*1e9);
//find the gain of parabolic reflector at given frequency  and daimeter
Gtdb=input("enter the value of gain of transmitting antenna in dB=");
Gt=10^(Gtdb/10);
//calculate Free space Loss for given frequency and distance between earth and satellite log10
R=input("enter the value of distance between earth and satellite=");
FSL=(4*%pi*R*1e3/lambda);
FSLdb=20*log10(FSL);
losses=input("enter the value of additional losses in dB")
Totallosses=FSLdb+losses
TL=10^(Totallosses/10);
//determine received power
Pt=input("enter the value of power transmitted in W=");
Grdb=input("enter the value receiver antenna gain in dB=");
Gr=10^(Grdb/10);;
Pr=Pt*Gt*Gr/TL;
Prdb=10*log10(Pr);
//Calculate noise power density and noise power
Ta=input("enter the value of antenna noise temperaturem in K=");
Tr=input("enter the value receiver noise temperature in K=");
B=input("enter the value receiver bandwidth MHz=");
En=Ta+Tr;//equivalent noise temperature
K=1.36e-23;//Boltzman constant
Pno=K*En*B*1e6;//noise power
Pnodb=10*log10(Pno);
Pnod=K*En;//noise power density
Pnoddb=10*log10(Pnod);
// signal to noise ratio
CN=Prdb-Pnodb;
CN0=Prdb-Pnoddb;
disp ('dB',CN,"Signal power to noise power ratio dB=");
disp ('dBHz',CN0,"Signal power to noise power density ratio dBHz=");
